﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class CCOWTest : System.Web.UI.Page
{
    #region Actions, Error Codes, Descriptions Shared with the ASPX

    //todo: move these to a class with a namespace so they can be referenced by this and by the station division authorization form
    //they are not all currently used, but this page may be expanded and may need them
    public static readonly string SentillionReasonDesc = "The sentillion components are not functioning. They are either missing or should be reinstalled.";
    public static readonly string SentillionReasonCode = "sentillion";
    public static readonly string ContextReasonDesc = "It is possible that user context sharing has been disabled by CPRS";
    public static readonly string ContextReasonCode = "context";
    public static readonly string LoginReasonDesc = "VistALink Login failed. There is either a problem connecting to the service or you are not authorized.";
    public static readonly string LoginReasonCode = "login";
    public static readonly string RequestStationAction = "requestStation";
    public static readonly string ConfirmAction = "confirm";
    public static readonly string ActionQueryField = "action";
    public static readonly string ReasonQueryField = "reason";
    public static readonly string VistaQueryField = "vista";
    public static readonly string InvalidDivisionErrorSnippet = "Division specified is invalid for user.";
    public static readonly string InvalidDivisionPleasantErrorPrefix = "The VIA service reports that you are not authorized for division ";
    public static readonly string DivisionNotSupportedFormat = "Division [{0}] not supported";
    public static readonly string SuccessMessage = "SUCCESS";
    public static readonly string VIASiteLookupSuccessPrefix = "The VIA service reports that your primary station is ";

    #endregion Error Codes and Descriptions Shared with the ASPX

    protected void Page_Load(object sender, EventArgs e)
    {
        if (Request.HttpMethod == "POST")
        {
            HandleLoggingRequest();
            return;
        }
    }

    private void HandleLoggingRequest()
    {
        StreamReader reader = new StreamReader(Request.InputStream);
        string logMessage = reader.ReadToEnd();
        Logging.WriteLogToFile(string.Format("StationDivisionAuthorization: Message from {0} on {1} [{2}]: {3}",
            Request.LogonUserIdentity.Name, Request.UserHostName, Request.UserHostAddress, logMessage));
    }
}